<?php
require_once __DIR__ . '/auth.php';
require_login();

header('Content-Type: application/json; charset=utf-8');

// Constrói endpoint a partir de API_BASE_URL e dos parâmetros recebidos
// Mantemos o token apenas no servidor (API_TOKEN) — mas se o cliente já
// passou token na query, não adicionamos outro.
$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';

// Monta query da requisição original (GET)
$queryParams = $_GET;
if (isset($queryParams['__no_token'])) {
    // opção para evitar envio do token do servidor (raro) -- remove a flag
    unset($queryParams['__no_token']);
} else {
    // se não houver token explicitamente em query, adiciona o token do servidor
    $hasToken = false;
    foreach ($queryParams as $k => $v) {
        if (strcasecmp($k, 'token') === 0) { $hasToken = true; break; }
    }
    if (!$hasToken) $queryParams['token'] = API_TOKEN;
}

// Cria URL final
$endpoint = rtrim(API_BASE_URL, '?') . '?' . http_build_query($queryParams);

// Inicia cURL
$ch = curl_init($endpoint);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 15);
curl_setopt($ch, CURLOPT_USERAGENT, 'LOB-Banners-Proxy/1.0');
curl_setopt($ch, CURLINFO_HEADER_OUT, true);

// Se for POST, encaminhar o body bruto e headers de content-type se presente
if ($method === 'POST') {
    $body = file_get_contents('php://input');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);

    $hdrs = [];
    if (!empty($_SERVER['CONTENT_TYPE'])) $hdrs[] = 'Content-Type: ' . $_SERVER['CONTENT_TYPE'];
    if (!empty($hdrs)) curl_setopt($ch, CURLOPT_HTTPHEADER, $hdrs);
}

// Executa
$response = curl_exec($ch);
$err = curl_error($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Modo debug para master (exibe endpoint montado e resposta) — só para administradores
if (isset($_GET['_debug']) && is_master()) {
    echo json_encode([
        'endpoint' => $endpoint,
        'method' => $method,
        'http_code' => $code,
        'curl_error' => $err,
        'response' => $response
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

if ($response === false) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Erro ao consultar API: ' . $err]);
    exit;
}

if ($code >= 400) {
    http_response_code($code);
    // repassa resposta externa (provavelmente JSON)
    echo $response;
    exit;
}

// repassa body (assume-se que API externa retorna JSON)
echo $response;
exit;